/***********************************************************************/
/*  This file is part of the ARM Toolchain package                     */
/*  Copyright KEIL ELEKTRONIK GmbH 2003 - 2006                         */
/***********************************************************************/
/*                                                                     */
/*  FlashDev.C:  Device Description for ST M28W320FCT (16-bit Bus)     */
/*               This flash is used on the LPC4350-SerizII board       */
/*               from Silica.                                          */
/*                                                                     */
/***********************************************************************/

#include "..\FlashOS.H"        // FlashOS Structures


struct FlashDevice const FlashDevice  =  {
   FLASH_DRV_VERS,             // Driver Version, do not modify!
   "M28W320FCT @ SerizII",          // Device Name 
   EXT16BIT,                   // Device Type
   0x1C000000,                   // Device Start Address
   0x00400000,                   // Device Size in Bytes (4MB)
   1024,                       // Programming Page Size
   0,                          // Reserved, must be 0
   0xFF,                       // Initial Content of Erased Memory
   100,                        // Program Page Timeout 100 mSec
   3000,                       // Erase Sector Timeout 3000 mSec

   // Specify Size and Address of Sectors on FCB device (bottom boot)
   //0x02000, 0x000000,          // Sector Size  8kB ( 8 Sectors)
   //0x10000, 0x010000,          // Sector Size 64kB (63 Sectors)

   // Specify Size and Address of Sectors on FCT device (top boot)
   0x10000, 0x000000,          // Sector Size 64kB (63 Sectors)
   0x02000, 0x3F0000,          // Sector Size  8kB (8 Sectors)
   SECTOR_END
};
